/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.xml;

import com.aptana.editor.common.CommonUtil;
import com.aptana.editor.common.text.rules.BreakingMultiLineRule;
import com.aptana.editor.common.text.rules.CharacterMapRule;
import com.aptana.editor.common.text.rules.MultiCharacterRule;
import com.aptana.editor.common.text.rules.WhitespaceDetector;
import com.aptana.editor.xml.text.rules.AttributeNameWordDetector;
import com.aptana.editor.xml.text.rules.BrokenStringRule;
import com.aptana.editor.xml.text.rules.TagNameWordDetector;
import com.aptana.editor.xml.text.rules.TagWordRule;
import com.aptana.xml.core.IXMLScopes;
import com.aptana.xml.core.parsing.XMLTokenType;
import java.util.ArrayList;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public class XMLTagScanner
extends RuleBasedScanner
implements IXMLScopes {
    private static final String[] QUOTED_STRING_BREAKS = new String[]{"/>", ">"};
    private final IToken doubleQuotedStringToken = this.createToken(XMLTokenType.DOUBLE_QUOTED_STRING);
    private final IToken singleQuotedStringToken = this.createToken(XMLTokenType.SINGLE_QUOTED_STRING);
    private final IToken equalToken = this.createToken(XMLTokenType.EQUAL);
    private boolean hasTokens;

    public XMLTagScanner() {
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new MultiLineRule("\"", "\"", this.doubleQuotedStringToken, '\\'));
        rules.add(new BreakingMultiLineRule("\"", "\"", QUOTED_STRING_BREAKS, this.doubleQuotedStringToken, '\\'));
        rules.add(new MultiLineRule("'", "'", this.singleQuotedStringToken, '\\'));
        rules.add(new BreakingMultiLineRule("'", "'", QUOTED_STRING_BREAKS, this.singleQuotedStringToken, '\\'));
        rules.add(new WhitespaceRule((IWhitespaceDetector)new WhitespaceDetector()));
        TagWordRule tagWordRule = new TagWordRule(new TagNameWordDetector(), this.createToken(XMLTokenType.TAG_NAME), true);
        rules.add((Object)tagWordRule);
        WordRule attributeWordRule = new WordRule((IWordDetector)new AttributeNameWordDetector(), this.createToken(XMLTokenType.ATTRIBUTE), true);
        rules.add(attributeWordRule);
        rules.add(new MultiCharacterRule("</", this.createToken(XMLTokenType.START_TAG)));
        rules.add(new MultiCharacterRule("/>", this.createToken(XMLTokenType.TAG_SELF_CLOSE)));
        CharacterMapRule charsRule = new CharacterMapRule();
        charsRule.add('<', this.createToken(XMLTokenType.START_TAG));
        charsRule.add('>', this.createToken(XMLTokenType.END_TAG));
        charsRule.add('=', this.equalToken);
        rules.add(charsRule);
        this.setRules(rules.toArray(new IRule[rules.size()]));
        this.setDefaultReturnToken(this.createToken(XMLTokenType.TEXT));
    }

    protected IToken createToken(XMLTokenType type) {
        return this.createToken(type.getScope());
    }

    protected IToken createToken(String string) {
        return CommonUtil.getToken((String)string);
    }

    public void setRange(IDocument document, int offset, int length) {
        super.setRange(document, offset, length);
        this.hasTokens = false;
    }

    public IToken nextToken() {
        IToken token;
        if (!this.hasTokens) {
            this.hasTokens = true;
            token = this.findBrokenToken();
            if (!token.isUndefined()) {
                return token;
            }
        }
        token = super.nextToken();
        return token;
    }

    private IToken findBrokenToken() {
        this.fTokenOffset = this.fOffset;
        this.fColumn = -1;
        return new BrokenStringRule(this.singleQuotedStringToken, this.doubleQuotedStringToken).evaluate((ICharacterScanner)this);
    }
}

